/*
 * Decompiled with CFR 0.152.
 */
package org.spec.updater;

import com.nothome.delta.Delta;
import com.nothome.delta.DiffWriter;
import com.nothome.delta.GDiffPatcher;
import com.nothome.delta.GDiffWriter;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.spec.updater.ChecksumInfo;

public class SpecUpdater {
    private static final String VERSION = "0.8";
    private static final String VERSION_DATE = "2020-12-11";
    private static final String COPYRIGHT_YEARS = "2016-2020";
    private static final int EX_OK = 0;
    private static final int EX_USAGE = 64;
    private static final int EX_SOFTWARE = 70;
    private static final int EX_IOERR = 74;

    public static void showUsage() {
        System.err.println("Usage : SPEC-updater update [infilename] [outfilename] [optional proxy host] [optional proxy port]");
    }

    public static void main(String[] args) {
        System.out.println("SPEC Binary Update Utility, Version 0.8, 2020-12-11");
        System.out.println("Copyright 2016-2020 Standard Performance Evaluation Corporation (SPEC)");
        System.out.println();
        if (args.length < 1) {
            SpecUpdater.showUsage();
            System.exit(64);
        } else {
            try {
                if ("create".equals(args[0])) {
                    if (args.length != 5) {
                        SpecUpdater.showUsage();
                        System.exit(64);
                    }
                    new SpecUpdater().create(args[1], args[2], args[3], args[4]);
                } else if ("localupdate".equals(args[0])) {
                    if (args.length != 4) {
                        SpecUpdater.showUsage();
                        System.exit(64);
                    }
                    new SpecUpdater().localupdate(args[1], args[2], args[3]);
                } else if ("checksum".equals(args[0])) {
                    if (args.length != 3) {
                        SpecUpdater.showUsage();
                        System.exit(64);
                    }
                    new SpecUpdater().checksum(args[1], args[2]);
                } else if ("update".equals(args[0])) {
                    if (args.length < 3 || args.length > 5) {
                        SpecUpdater.showUsage();
                        System.exit(64);
                    }
                    String proxyHost = args.length < 4 ? null : args[3];
                    int proxyPort = args.length < 5 ? 80 : Integer.parseInt(args[4]);
                    new SpecUpdater().update(args[1], args[2], null, proxyHost, proxyPort);
                } else if ("update-test".equals(args[0])) {
                    if (args.length < 4 || args.length > 6) {
                        SpecUpdater.showUsage();
                        System.exit(64);
                    }
                    String proxyHost = args.length < 5 ? null : args[4];
                    int proxyPort = args.length < 6 ? 80 : Integer.parseInt(args[5]);
                    new SpecUpdater().update(args[2], args[3], args[1], proxyHost, proxyPort);
                } else {
                    SpecUpdater.showUsage();
                    System.exit(64);
                }
            }
            catch (IOException x) {
                System.err.println("Exception processing " + args[0] + ": " + x);
                x.printStackTrace();
                System.exit(74);
            }
            catch (Exception x) {
                System.err.println("Exception processing " + args[0] + ": " + x);
                x.printStackTrace();
                System.exit(70);
            }
            System.exit(0);
        }
    }

    public void create(String oldfilename, String newfilename, String gdiffname, String dbname) throws NoSuchAlgorithmException, IOException {
        File oldfile = new File(oldfilename);
        File newfile = new File(newfilename);
        try (FileOutputStream out = new FileOutputStream(gdiffname);){
            GDiffWriter writer = new GDiffWriter((OutputStream)out);
            new Delta().compute(oldfile, newfile, (DiffWriter)writer);
        }
        this.gzipFile(gdiffname, gdiffname + ".gz");
        String chk1 = this.getChecksum(oldfilename);
        String chk2 = this.getChecksum(gdiffname);
        String chk3 = this.getChecksum(newfilename);
        System.out.println("chk1 " + chk1 + ", chk2 " + chk2 + ", chk3 " + chk3 + "\n");
        try (FileOutputStream out = new FileOutputStream(new File(dbname), true);
             PrintWriter pw = new PrintWriter(out);){
            pw.println(oldfilename + "," + chk1 + "," + String.valueOf(oldfile.length()) + "," + gdiffname + "," + chk2 + "," + chk3);
        }
    }

    @Deprecated
    public void checksum(String filename, String outfilename) throws NoSuchAlgorithmException, IOException {
        String chk1 = this.getChecksum(filename);
        System.out.println("chk1 " + chk1 + "\n");
        try (FileOutputStream out = new FileOutputStream(new File("ptd-checksums.chk"), true);
             PrintWriter pw = new PrintWriter(out);){
            pw.println(filename + "," + chk1);
        }
    }

    public void update(String filename, String outfilename, String testFile, String proxyHost, int proxyPort) throws IOException {
        Proxy proxy = proxyHost == null ? null : new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyHost, proxyPort));
        File infile = new File(filename);
        if (!infile.exists()) {
            throw new FileNotFoundException("Input file " + filename + " does not exist; aborting.");
        }
        long inputFileSize = infile.length();
        File outfile = new File(outfilename);
        if (outfile.exists()) {
            throw new IOException("Output file " + outfilename + " already exists; aborting.");
        }
        if (testFile == null) {
            System.out.println("Fetching latest update file from www.spec.org");
            try {
                this.fetchFile("http://www.spec.org/power/ptd_patches/spec-chksums.gdiff.bin", "spec-chksums.gdiff.bin", proxy);
            }
            catch (IOException x) {
                throw new IOException("Error fetching update file from www.spec.org", x);
            }
        }
        System.out.println("Fetching test update file " + testFile);
        try {
            this.fetchFile("http://www.spec.org/power/ptd_patches/" + testFile, "spec-chksums.gdiff.bin", proxy);
        }
        catch (IOException x) {
            throw new IOException("Error fetching test update file from www.spec.org", x);
        }
        ArrayList<ChecksumInfo> checksums = new ArrayList<ChecksumInfo>();
        try (FileReader fr = new FileReader("spec-chksums.gdiff.bin");
             BufferedReader br = new BufferedReader(fr);){
            String line;
            String firstLine = br.readLine();
            if (!firstLine.startsWith("SPEC")) {
                System.err.println("Did not receive a valid updates file from spec.org, exiting.");
                System.err.println("First line was '" + firstLine + "'");
                throw new IOException("Invalid file format for spec-chksums.gdiff.bin");
            }
            while ((line = br.readLine()) != null) {
                String[] csvparts = line.split(",");
                checksums.add(new ChecksumInfo(csvparts[0], csvparts[1], Long.parseLong(csvparts[2]), csvparts[3], csvparts[4], csvparts[5]));
            }
        }
        catch (IOException x) {
            throw new IOException("Exception reading spec-chksums.gdiff.bin", x);
        }
        ChecksumInfo matchedChecksum = null;
        try {
            System.out.println("Calculating checksum for input file " + filename + "...");
            String chk1 = this.getChecksum(filename);
            for (ChecksumInfo checksum : checksums) {
                if (!checksum.matches(chk1, inputFileSize)) continue;
                System.out.println("Checksum and size of " + checksum.getBinaryName() + " are a match to input file.\n");
                matchedChecksum = checksum;
                if (chk1 == checksum.getTargetChecksum()) {
                    System.out.println("Hello McFly! " + filename + " is already current version!!!!!\n");
                    System.out.println("Nothing to do here, exiting!!!!!\n");
                    System.exit(0);
                }
                break;
            }
        }
        catch (IOException x) {
            throw new IOException("Exception calculating checksum for input file " + filename, x);
        }
        if (matchedChecksum == null) {
            System.err.println("Unable to identify " + filename + " as a released SPEC binary!");
        } else {
            File binfile;
            String gdiffFile = matchedChecksum.getPatchFileName();
            String gdiffZip = gdiffFile + ".gz";
            System.out.println("Fetching patch file from www.spec.org");
            try {
                this.fetchFile("http://www.spec.org/power/ptd_patches/" + gdiffZip, gdiffZip, proxy);
            }
            catch (IOException x) {
                throw new IOException("Exception fetching patch file from www.spec.org: gdiffZip", x);
            }
            this.unGzipFile(gdiffZip, gdiffFile);
            File patchfile = new File(gdiffFile);
            if (!patchfile.exists()) {
                throw new FileNotFoundException("Patch file " + gdiffFile + " not found; aborting");
            }
            String chk1 = this.getChecksum(gdiffFile);
            System.out.println("Calculating checksum for patch file " + gdiffFile + "...");
            if (!chk1.equals(matchedChecksum.getPatchChecksum())) {
                patchfile.delete();
                throw new IOException("Patch file is corrupt; please try again.");
            }
            System.out.println("Patch file is valid.\n");
            System.out.println("Applying patch " + gdiffFile);
            try {
                new GDiffPatcher().patch(infile, patchfile, outfile);
            }
            catch (IOException x) {
                patchfile.delete();
                throw new IOException("Exception applying patch", x);
            }
            System.out.println("New file " + outfilename + " created");
            String chk3 = this.getChecksum(outfilename);
            System.out.println("Calculating checksum for newly created file " + outfilename + "...");
            if (!chk3.equals(matchedChecksum.getTargetChecksum())) {
                patchfile.delete();
                throw new IOException("Created file is corrupt; please try again.");
            }
            System.out.println("Created file is valid.\n");
            patchfile.delete();
            File gzfile = new File(gdiffZip);
            if (gzfile.exists()) {
                gzfile.delete();
            }
            if ((binfile = new File("spec-chksums.gdiff.bin")).exists()) {
                binfile.delete();
            }
        }
    }

    public void localupdate(String infilename, String patchfilename, String outfilename) throws IOException {
        File infile = new File(infilename);
        if (!infile.exists()) {
            throw new FileNotFoundException("Input file " + infilename + " does not exist; aborting.");
        }
        File outfile = new File(outfilename);
        if (outfile.exists()) {
            throw new IOException("Output file " + outfilename + " already exists; aborting.");
        }
        File patchfile = new File(patchfilename);
        if (!patchfile.exists()) {
            throw new FileNotFoundException("Patch file " + patchfilename + " not found; aborting");
        }
        System.out.println("Applying patch...");
        try {
            new GDiffPatcher().patch(infile, patchfile, outfile);
        }
        catch (IOException x) {
            throw new IOException("Exception applying patch", x);
        }
        System.out.println("New file " + outfilename + " successfully created!");
    }

    public void fetchFile(String URLstring, String filename, Proxy proxy) throws IOException {
        int offset;
        URL u = new URL(URLstring);
        URLConnection uc = proxy != null ? u.openConnection(proxy) : u.openConnection();
        int contentLength = uc.getContentLength();
        if (contentLength <= 0) {
            throw new FileNotFoundException("Patch file " + URLstring + " not found; aborting");
        }
        byte[] data = new byte[contentLength];
        try (InputStream raw = uc.getInputStream();
             BufferedInputStream in = new BufferedInputStream(raw);){
            int bytesRead = 0;
            for (offset = 0; offset < contentLength; offset += bytesRead) {
                bytesRead = in.read(data, offset, data.length - offset);
                if (bytesRead != -1) continue;
                break;
            }
        }
        if (offset != contentLength) {
            throw new IOException("Only read " + offset + " bytes; Expected " + contentLength + " bytes");
        }
        System.out.println("Read " + contentLength + " bytes from www.spec.org");
        var10_10 = null;
        try (FileOutputStream out = new FileOutputStream(filename);){
            out.write(data);
            out.flush();
        }
        catch (Throwable throwable) {
            var10_10 = throwable;
            throw throwable;
        }
    }

    public byte[] createChecksum(String filename) throws NoSuchAlgorithmException, IOException {
        try (FileInputStream fis = new FileInputStream(filename);){
            int numRead;
            byte[] buffer = new byte[1024];
            MessageDigest complete = MessageDigest.getInstance("SHA-256");
            do {
                if ((numRead = fis.read(buffer)) <= 0) continue;
                complete.update(buffer, 0, numRead);
            } while (numRead != -1);
            byte[] byArray = complete.digest();
            return byArray;
        }
    }

    public String getChecksum(String filename) throws IOException {
        try {
            byte[] b = this.createChecksum(filename);
            String result = "";
            for (int i = 0; i < b.length; ++i) {
                result = result + Integer.toString((b[i] & 0xFF) + 256, 16).substring(1);
            }
            return result;
        }
        catch (NoSuchAlgorithmException x) {
            throw new IOException("Exception calculating checksum", x);
        }
    }

    public void gzipFile(String source_filepath, String destination_zip_filepath) throws IOException {
        byte[] buffer = new byte[1024];
        try (FileOutputStream fileOutputStream = new FileOutputStream(destination_zip_filepath);
             GZIPOutputStream gzipOutputStream = new GZIPOutputStream(fileOutputStream);){
            try (FileInputStream fileInput = new FileInputStream(source_filepath);){
                int bytes_read;
                while ((bytes_read = fileInput.read(buffer)) > 0) {
                    gzipOutputStream.write(buffer, 0, bytes_read);
                }
            }
            gzipOutputStream.finish();
        }
    }

    public void unGzipFile(String compressedFile, String decompressedFile) throws IOException {
        byte[] buffer = new byte[1024];
        try (FileInputStream fileIn = new FileInputStream(compressedFile);
             GZIPInputStream gZIPInputStream = new GZIPInputStream(fileIn);
             FileOutputStream fileOutputStream = new FileOutputStream(decompressedFile);){
            int bytes_read;
            while ((bytes_read = gZIPInputStream.read(buffer)) > 0) {
                fileOutputStream.write(buffer, 0, bytes_read);
            }
        }
    }
}

